<?php
class vB_BlockType_Dbtech_vbmail_form extends vB_BlockType
{
	/**
	 * The Productid that this block type belongs to
	 * Set to '' means that it belongs to vBulletin forum
	 *
	 * @var string
	 */
	protected $productid = 'dbtech_vbmail';
	
	/**
	 * The block settings
	 * It uses the same data structure as forum settings table
	 * e.g.:
	 * <code>
	 * $settings = array(
	 *     'varname' => array(
	 *         'defaultvalue' => 0,
	 *         'optioncode'   => 'yesno'
	 *         'displayorder' => 1,
	 *         'datatype'     => 'boolean'
	 *     ),
	 * );
	 * </code>
	 * @see print_setting_row()
	 *
	 * @var string
	 */
	protected $settings = array(
		'dbtech_vbmail_dummy' => array(
			'defaultvalue' => 1,
			'optioncode'   => 'yesno',
			'displayorder' => 9001,
			'datatype'     => 'boolean'
		),
	);

	/**
	 * This function allows the data returned to be cached.
	 *
	 * @return array 	The results
	 */
	public function getData()
	{
		if (!class_exists('VBMAIL'))
		{
			// Not displaying any results
			return '';
		}		
	}

	public function getHTML()
	{
		if (!class_exists('VBMAIL'))
		{
			// Not displaying any results
			return '';
		}	

		$mailinglists = '';
		foreach ((array)VBMAIL::$cache['mailinglist'] as $mailinglistid => $mailinglist)
		{
			if (!$mailinglist['active'])
			{
				// Skip this
				continue;
			}
			
			if (!$mailinglist['external'])
			{
				// Skip this
				continue;
			}

			// Load the permissions
			$permarray = VBMAIL::load_mailinglist_permissions($mailinglist);
			
			if ($permarray['cannotview'] AND !$permarray['canview'])
			{
				// Can't view this mailing list
				continue;
			}			
			
			$templater = vB_Template::create('option');
				$templater->register('optionvalue', $mailinglistid);
				$templater->register('optiontitle', $mailinglist['title']);
			$mailinglists .= $templater->render();
		}

		if (!$mailinglists)
		{
			// Ensure we don't display it if we have no mailing lists
			return '';
		}
		
		$templater = vB_Template::create('dbtech_vbmail_block_form');
			$templater->register('blockinfo', 		$this->blockinfo);
			$templater->register('mailinglists',	$mailinglists);
		return $templater->render();
	}

	/**
	 * Generates a hash used for block caching.
	 * If the block output depends on permissions,
	 * ensure it's unique either per-user or for all
	 * users with similar permissions
	 *
	 * @return string 	The hash
	 */
	public function getHash()
	{
		$context = new vB_Context('forumblock' ,
		array(
			'blockid' 		=> $this->blockinfo['blockid'],
			'permissions' 	=> $this->userinfo['forumpermissions'],
			'ignorelist' 	=> $this->userinfo['ignorelist'],
			THIS_SCRIPT)
		);

		return strval($context);
	}
}